/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.api;

import filenet.sim.api.VWScenarioPriorityField;
import filenet.sim.api.VWScenarioPriorityType;
import filenet.sim.api.VWScenarioRoleDefinition;
import filenet.sim.api.VWScenarioValidationError;
import filenet.vw.api.VWException;
import filenet.vw.api.VWSystemConfiguration;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public final class VWScenarioQueueAssignment
implements Serializable,
Cloneable {
    private VWScenarioRoleDefinition m_roleDef = null;
    private String m_queueName = null;
    private int m_index = 0;
    private int m_priorityType = 3;
    private List m_fields = Collections.synchronizedList(new ArrayList());

    protected VWScenarioQueueAssignment(String queueName, int priority, int index, VWScenarioRoleDefinition roleDef) throws VWException {
        this.m_roleDef = roleDef;
        this.setQueueName(queueName);
        this.setPriorityType(priority);
        this.setIndex(index);
    }

    public String getQueueName() {
        return this.m_queueName;
    }

    public void setQueueName(String queueName) throws VWException {
        if (queueName == null) {
            throw new VWException("sim.api.VWScenarioQueueAssignment.NullQueueNameParameter", "The queueName parameter can not be null.");
        }
        this.m_queueName = queueName;
    }

    public int getPriorityType() {
        return this.m_priorityType;
    }

    public void setPriorityType(int priority) throws VWException {
        if (!VWScenarioPriorityType.isValid(priority)) {
            throw new VWException("sim.api.VWScenarioQueueAssignment.InvalidQueuePriorityType", "Type {0} is not a valid queue priority type.", new Integer(priority));
        }
        this.m_priorityType = priority;
    }

    public VWScenarioPriorityField createPriorityField(String fieldName, int fieldType, int order) throws VWException {
        if (this.getFieldIndex(fieldName) != -1) {
            throw new VWException("sim.api.VWScenarioQueueAssignment.FieldAlreadyExists", "A priority field with the name {0} has already been created.", fieldName);
        }
        VWScenarioPriorityField field = new VWScenarioPriorityField(fieldName, fieldType, order, this.m_fields.size() + 1);
        this.m_fields.add(field);
        return field;
    }

    protected VWScenarioPriorityField createPriorityField(String fieldName, int fieldType, int order, int index) throws VWException {
        int i;
        if (this.getFieldIndex(fieldName) != -1) {
            throw new VWException("sim.api.VWScenarioQueueAssignment.FieldAlreadyExists", "A priority field with the name {0} has already been created.", fieldName);
        }
        VWScenarioPriorityField[] fields = this.getPriorityFields();
        for (i = 0; fields != null && i < fields.length && index > fields[i].getIndex(); ++i) {
        }
        VWScenarioPriorityField field = new VWScenarioPriorityField(fieldName, fieldType, order, index);
        this.m_fields.add(i, field);
        return field;
    }

    public VWScenarioPriorityField[] getPriorityFields() {
        if (this.m_fields.size() == 0) {
            return null;
        }
        return this.m_fields.toArray(new VWScenarioPriorityField[0]);
    }

    public VWScenarioPriorityField getPriorityField(String fieldName) throws VWException {
        if (fieldName == null) {
            throw new VWException("sim.api.VWScenarioPriorityField.NullFieldNameParameter", "The fieldName parameter can not be null.");
        }
        int index = this.getFieldIndex(fieldName);
        if (index == -1) {
            throw new VWException("sim.api.VWScenarioPriorityField.FieldNotFound", "Field {0} has not been created for this queue assignment.", fieldName);
        }
        return (VWScenarioPriorityField)this.m_fields.get(index);
    }

    public void deletePriorityField(String fieldName) throws VWException {
        if (fieldName == null) {
            throw new VWException("sim.api.VWScenarioPriorityField.NullFieldNameParameter", "The fieldName parameter can not be null.");
        }
        int index = this.getFieldIndex(fieldName);
        if (index == -1) {
            throw new VWException("sim.api.VWScenarioPriorityField.FieldNotFound", "Field {0} has not been created for this queue assignment.", fieldName);
        }
        this.m_fields.remove(index);
    }

    public void reorderPriorityFields(String[] fieldNames) throws VWException {
        List<VWScenarioPriorityField> fields = Collections.synchronizedList(new ArrayList());
        if (fieldNames == null) {
            throw new VWException("sim.api.VWScenarioPriorityField.NullFieldNamesParameter", "Parameter fieldNames cannot be null.");
        }
        if (fieldNames.length != this.m_fields.size()) {
            throw new VWException("sim.api.VWScenarioPriorityField.ReorderArrayLength", "Parameter fieldNames actual length is {0}, expected length should be {1}.", String.valueOf(fieldNames.length), String.valueOf(this.m_fields.size()));
        }
        if (fieldNames.length < 2) {
            return;
        }
        for (int i = 0; i < fieldNames.length; ++i) {
            for (int j = 0; j < fieldNames.length; ++j) {
                if (j == i || fieldNames[i] != fieldNames[j]) continue;
                throw new VWException("sim.api.VWScenarioPriorityField.ReorderArrayDuplicateEntry", "Parameter fieldNames, field name {0} occurs more than once in the array.", fieldNames[i]);
            }
            int index = this.getFieldIndex(fieldNames[i]);
            if (index == -1) {
                throw new VWException("sim.api.VWScenarioPriorityField.ReorderArrayInvalidField", "Parameter fieldNames contains field name {0}, which is not found on this queue assignment.", fieldNames[i]);
            }
            VWScenarioPriorityField field = (VWScenarioPriorityField)this.m_fields.get(index);
            field.setIndex(i);
            fields.add(field);
        }
        this.m_fields = fields;
    }

    public void validate(Vector EDefVector, VWSystemConfiguration sysConfig) throws VWException {
        if (sysConfig != null) {
            try {
                sysConfig.getQueueDefinition(this.getQueueName());
            }
            catch (VWException e) {
                VWScenarioValidationError theError = new VWScenarioValidationError(4, 1, this.m_roleDef.getName(), this.getQueueName(), e.getMessage() + " (" + this.getQueueName() + ")");
                EDefVector.addElement(theError);
            }
        }
    }

    public String toString() {
        return this.getQueueName();
    }

    protected Object clone() {
        VWScenarioQueueAssignment clone = null;
        try {
            clone = (VWScenarioQueueAssignment)super.clone();
            clone.m_fields = Collections.synchronizedList(new ArrayList());
            Iterator i = this.m_fields.iterator();
            while (i.hasNext()) {
                VWScenarioPriorityField field = (VWScenarioPriorityField)((VWScenarioPriorityField)i.next()).clone();
                clone.m_fields.add(field);
            }
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clone;
    }

    private int getFieldIndex(String fieldName) {
        int index = -1;
        int counter = 0;
        ListIterator iterator = this.m_fields.listIterator();
        while (iterator.hasNext()) {
            if (((VWScenarioPriorityField)iterator.next()).getName().equals(fieldName)) {
                index = counter;
                break;
            }
            ++counter;
        }
        return index;
    }

    protected int getIndex() {
        return this.m_index;
    }

    protected void setIndex(int index) {
        this.m_index = index;
    }

    protected void setRole(VWScenarioRoleDefinition role) {
        this.m_roleDef = role;
    }
}

